/*! *********************************************************************************
 * \addtogroup Wireless UART Profile
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/
#include "FunctionLib.h"
#include "ble_general.h"
#include "gatt_db_app_interface.h"
#include "gatt_server_interface.h"
#include "gap_interface.h"
#include "wireless_uart_interface.h"
/************************************************************************************
*************************************************************************************
* Private constants & macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/

/*! wireless_uart Service - Subscribed Client*/
static deviceId_t mWus_SubscribedClientId;

/************************************************************************************
*************************************************************************************
* Private functions prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/
bleResult_t Wus_Start(wusConfig_t *pServiceConfig)
{
    mWus_SubscribedClientId = gInvalidDeviceId_c;

    return gBleSuccess_c;
}

bleResult_t Wus_Stop(wusConfig_t *pServiceConfig)
{
    return Wus_Unsubscribe();
}

bleResult_t Wus_Subscribe(deviceId_t clientDeviceId)
{
    if (mWus_SubscribedClientId != gInvalidDeviceId_c)
    {
        mWus_SubscribedClientId = clientDeviceId;
    }

    return gBleSuccess_c;
}

bleResult_t Wus_Unsubscribe(void)
{
    mWus_SubscribedClientId = gInvalidDeviceId_c;
    return gBleSuccess_c;
}

/************************************************************************************
*************************************************************************************
* Private functions
*************************************************************************************
************************************************************************************/
/*! *********************************************************************************
 * @}
 ********************************************************************************** */
